{******************************************************************************}
{                                                                              }
{  Demo program for TIconGrabber                                               }
{                                                                              }
{  Copyright  1996 Sadman Software.  All Rights Reserved.                     }
{  100717.3531@compuserve.com                                                  }
{                                                                              }
{  V1.00 9-May-1996                                                            }
{******************************************************************************}
unit MainFrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons, ExtCtrls, Menus, IconGrab;

type
  TMainForm = class(TForm)
    OpenDialog: TOpenDialog;
    IconGrabber1: TIconGrabber;
    Panel1: TPanel;
    IconImage: TImage;
    Panel2: TPanel;
    btExit: TSpeedButton;
    btOpen: TSpeedButton;
    spIconNumber: TSpinEdit;
    lbNumberOfIcons: TLabel;
    SaveDialog: TSaveDialog;
    btSaveToFile: TSpeedButton;
    btViewIcons: TSpeedButton;
    procedure Exit1Click(Sender: TObject);
    procedure OpenFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure spIconChange(Sender: TObject);
    procedure SaveIconToFileClick(Sender: TObject);
    procedure btViewIconsClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetFilename(const filename: string);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses
   IconView;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   { load the icon from the application executable initially }
   SetFilename(Application.Exename);
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TMainForm.OpenFileClick(Sender: TObject);
begin
   with OpenDialog do
      if Execute then
         SetFilename(Filename);
end;

procedure TMainForm.SaveIconToFileClick(Sender: TObject);
begin
   with SaveDialog do
      if Execute then
         IconImage.Picture.SaveToFile(Filename);
end;

procedure TMainForm.SetFilename(const filename: string);
var
   cr: TCursor;
begin
   cr := Screen.Cursor;
   Screen.Cursor := crHourGlass;    
   try
      Caption := filename;
      spIconNumber.Value := 0;
      IconGrabber1.Filename := filename;
      spIconNumber.MaxValue := IconGrabber1.NumberOfIcons - 1;
      if spIconNumber.MaxValue < spIconNumber.MinValue  then
         spIconNumber.MaxValue := spIconNumber.MinValue;

      { enable/disable other functions depending how many icons there are }
      spIconNumber.Enabled := IconGrabber1.NumberOfIcons > 1;
      btViewIcons.Enabled := IconGrabber1.NumberOfIcons > 1;
      btSaveToFile.Enabled := IconGrabber1.NumberOfIcons > 0;

      { show how many icons are in the file }
      lbNumberOfIcons.Caption := IntToStr(IconGrabber1.NumberOfIcons) + ' icon';
      if IconGrabber1.NumberOfIcons <> 1 then
         lbNumberOfIcons.Caption := lbNumberOfIcons.Caption + 's';
   finally
      Screen.Cursor := cr;
   end;
end;

procedure TMainForm.spIconChange(Sender: TObject);
begin
   try
      IconImage.Picture.Icon := IconGrabber1.Icons[spIconNumber.Value]
   except 
      IconImage.Picture.Icon := nil;
   end;
end;

procedure TMainForm.btViewIconsClick(Sender: TObject);
begin
   with TViewIconsDlg.Create(self) do
      try
         IconGrabber := IconGrabber1;
         IconIndex := spIconNumber.Value;
         if ShowModal = mrOk then
            spIconNumber.Value := IconIndex;
      finally
         free;
      end;
end;

end.
